#!/usr/bin/perl
#
# generateRouters.pl

use strict;
use Getopt::Long;
use Term::ReadKey;

my $wingui_routers     = "./saproute.ini";
my $javagui_routers    = "./routers.txt";
my $debug = 0;
my $version = 0.6;
my $key;
my $overwrite;

Getopt::Long::Configure( 'no_ignore_case' );
Getopt::Long::Configure( 'bundling' );

my $options = GetOptions( 'w|winguirouters:s'		=>	\$wingui_routers,
													'j|javaguirouters:s'	=>	\$javagui_routers,
													'o|overwrite'					=>	\$overwrite,
													'h|help:s'						=>  sub { printhelp(); exit; },
													'v|version:s'					=>	sub { printversion(); exit; } );													

if ($overwrite != "1") {
	if (-e $javagui_routers) {
		ReadMode('cbreak');
		print "The specified output file <" . $javagui_routers . "> already exists. Do you want to overwrite it? [y/n]";
		$key = ReadKey(0);
		ReadMode('normal');
		if ($key  ne "y") {
			print "\nExiting...\n";
	   	exit;
		}
		else {
			print "\nOverwriting existing file...\n";
		}
	}
}

open WINGUI_ROUTERS,		"<$wingui_routers"			or die "Open $wingui_routers failed: $!";
open JAVAGUI_ROUTERS,		">$javagui_routers"			or die "Open $javagui_routers failed: $!";

convert_routers();

close WINGUI_ROUTERS;
close JAVAGUI_ROUTERS; 	

sub convert_routers {
	print "DEBUG: Converting Routers...\n\n" if ($debug);
	my @javagui_routers_list;
	while(<WINGUI_ROUTERS>)
	{
	  s/(\015|\012)+$//;
	  last if /\[Default\]/;
		chomp;	
		my $line = $_;
		if($line =~/\/H\//) {
			print "DEBUG: line should contain \/H\/ = <", $line, ">\n" if ($debug);
			$line =~ s/=/ : /;
			print "DEBUG: line should now contain : = <", $line, ">\n" if ($debug);
			$line =~ s/\/H\/$//;
			print "DEBUG: line should have the trailing /H/ removed = <", $line, ">\n" if ($debug);
			push (@javagui_routers_list, $line);
		}
	}
	foreach (@javagui_routers_list) {
		print JAVAGUI_ROUTERS $_ . "\n";
	}
}

sub printhelp {
	print "Syntax: generateRouters.pl [-w filename] [-j filename] [-o]\n";
	print "-w | --winrouters:    <WinGUI Routers File>               (INPUT FILE,  default: ./saproute.ini)\n";
	print "-j | --javarouters:   <JavaGUI Routers File>              (OUTPUT FILE, default: ./routers.txt)\n";
	print "-o | --overwrite:     Overwrites an existing output file without prompting.\n";
	print "-h | --help:          Prints this help text.\n";
	print "-v | --version:       Prints the version of this script.\n";
}

sub printversion {
	print "Version: " . $version . "\n";
}